/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime (u_Elapsed*0.2) // Slowed dwn by TheEmu.
#define iResolution u_WindowSize
#define iMouse AUTO_MOUSE

/////////////////////////////////////////////////////////////////////////////////

#define C(A,B,C) if(p.x==(A).x&&p.y==(A).y&&T>float(B)){if(B==16&&T>81.||B==61&&T>70.)return false;float d=distance(f,vec2(.5));if(d<=.5){pl=C;pl=B==int(T)&&abs(f.x-.5)<=.2&&abs(f.y-.5)<=.2?1.-pl:pl;return true;}}

float T=mod(iGlobalTime,55.)*2.;
mat4 g[3];

vec2 coord(float x, float n)
{
    float s=.0;
    for(float i=4.;i>=0.;i--)
    {
        if(x>=n)
        {
            x-=n;
            s+=pow(2.,i);
        }
        n*=.5;
    }
    return vec2(x,s);
}

vec4 convert(float x)
{
    vec4 s;
    vec2 co=coord(x,524288.); s.x=co.y;
    co=coord(co.x,16384.); s.y=co.y;
    co=coord(co.x,512.); s.z=co.y;
    co=coord(co.x,16.); s.w=co.y;
	return s;
}

bool move(vec2 p, out float pl)
{
    g[0]=mat4(102916.,167024.,540849.,109098.
             ,462342.,363985.,509392.,571500.
             ,174417.,176689.,477775.,573006.
             ,443949.,606768.,607794.,538156.);
    g[1]=mat4(474544.,508338.,510546.,411055.
             ,410030.,506223.,411972.,331044.
             ,526627.,398662.,203172.,429124.
             ,103523.,100456.,70730.,74857.);
    g[2]=mat4(76938.,109707.,143436.,43179.
             ,208009.,73897.,113807.,112720.
             ,209098.,205066.,81038.,144429.
             ,79043.,200932.,198883.,169507.);
    vec2 f=fract(p);
    p=ceil(p);
    for(int i=0;i<3;i++)
    {
        for(int j=0;j<4;j++)
        {
            for(int k=0;k<4;k++)
            {
                int nb=2*k+8*j+32*i;
                vec4 conv=convert(g[i][j][k]);
                C(conv.xy,nb,.0) C(conv.zw,nb+1,1.)
            }
        }
    }
    return false;
}

vec3 white(vec2 p)
{
    p=2.*fract(p)-1.;
    float r=length(p);
    vec3 c=1.3*vec3(.6,.45,.15);
    if(r<1.)
    {
        float f=smoothstep(1.,.9,r);
        c=mix(c,vec3(.7,.7,.6),f);
        c*=1.2-r/5.;
        f=smoothstep(.98,.0,length(p-vec2(.2,.24)));
        c+=f*.4;
    }
    return c;
}

vec3 black(vec2 p)
{
    p=2.*fract(p)-1.;
    float r=length(p);
    vec3 c=vec3(.6,.45,.15);
    if(r<1.)
    {
        float f=smoothstep(1.,.85,r);
        c=mix(c,vec3(0),f);
        f=smoothstep(.0,.98,r);
        c=mix(c,vec3(0,0,.2),1.-f);
        f=smoothstep(.98,.0,length(p-vec2(.2,.24)));
        c+=f*.7;
    }
    return c;
}

vec3 board(vec2 p)
{
    if(p.x>=.5&&p.x<18.5&&p.y>=.5&&p.y<18.5)
    {
        float d;
        vec2 f=fract(p);
        if(distance(p,vec2(9.5))<=.15
         ||distance(p,vec2(3.5,9.5))<=.15
         ||distance(p,vec2(9.5,3.5))<=.15
         ||distance(p,vec2(3.5,3.5))<=.15
         ||distance(p,vec2(15.5,9.5))<=.15
         ||distance(p,vec2(9.5,15.5))<=.15
         ||distance(p,vec2(15.5,15.5))<=.15
         ||distance(p,vec2(3.5,15.5))<=.15
         ||distance(p,vec2(15.5,3.5))<=.15)
            return vec3(0);
        if(abs(.5-f.x)<=.07||abs(.5-f.y)<=.07)
            return mix(vec3(0),vec3(.6,.45,.15),smoothstep(.0,.07,min(abs(.5-f.x),abs(.5-f.y))));
    }
    return p.x>=-.5&&p.x<19.5&&p.y>=-.5&&p.y<19.5?vec3(.6,.45,.15):vec3(.1);
}

void mainImage( out vec4 O, in vec2 U )
{
    vec2 R=iResolution.xy,
         p=11.*(U+U-R)/R.y;
    float pl;
    p+=9.5;
    vec3 c=board(p);
    if(move(p,pl))c=pl==1.?white(p):black(p);
    vec2 q=(p+22.)/24.;
    O=vec4(sqrt(q.x*q.y)*.8*c,1.0);
}

void main ( void )
{ mainImage ( gl_FragColor, gl_FragCoord.xy );
}